-- Time-stamp: <2015-07-04 23:01:48 novatux>
-- Création : 2015-07-04T23:00:01+0200

-- Exemple de requêtes utilisables avec la base France et SQLite
-- Yvon Henel, alias « Le TeXnicien de surface »

select r.nom,d.nom,c.nom
from regions as r
join departements as d on r.RegId = d.RegId
join communes as c on d.ChefLieu = c.ComId
where r.RegId>10
order by r.RegId;

---------------------------------------------------------------------------

select r.nom "Régions",d.nom "Départements",c.nom "Communes"
from regions as r
join departements as d on r.RegId = d.RegId
join communes as c on d.ChefLieu = c.ComId
where round(r.RegId/10)=2;

---------------------------------------------------------------------------

-- communes hors Nord dont le nom est le même que celui d'une commune du Nord

select c1.nom,c1.ComId,c2.nom,c2.ComId
from communes as c1 inner
join communes as c2 on c1.nom=c2.nom and c1.ComId<>c2.ComId
where c1.DepId = 59;

---------------------------------------------------------------------------

-- quelles communes sont dans la liste des communes mais pas dans
-- celles de population ?

select ComId, nom
from communes
where ComId in
			(select ComId from communes
			 except
			 select CODGEO	from population);

---------------------------------------------------------------------------

-- communes dans population mais pas dans communes

select CODGEO from population
except
select ComId from communes;

---------------------------------------------------------------------------

-- communes du 1 canton du Nord avec population 2009

select c.DepId,c.Nom,p.P09_POP
from communes c
join population p on p.CODGEO=c.ComId
where c.DepId =59 and c.CantonId=1;

---------------------------------------------------------------------------

-- création du vue sur la population du nord

create view popnord as
			 select c.nom,c.ComId,c.CantonId,p.P09_POP
			 from communes as c
			 join population as p on p.CODGEO=c.ComId
			 where c.DepId=59;

---------------------------------------------------------------------------

-- noms des départements contenant des villes de plus de 250 000 habitants

select d.nom
from departements as d
join communes as c on c.DepId=d.DepId
join population as p on p.CODGEO = c.comid
where p.P09_POP > 250000;

---------------------------------------------------------------------------

select d.nom as "Département",r.nom as "Région"
from departements as d
natural join regions as r;

---------------------------------------------------------------------------

-- renvoie les départements qui sont aussi des régions même que :

select d.nom as "Département",r.nom as "Région"
from departements as d
join regions as r on r.nom=d.nom and r.RegId=d.RegId;

---------------------------------------------------------------------------

-- pour montrer une jointure externe gauche (seule possible avec sqlite) 

select *
from zeat left outer
join regions;

---------------------------------------------------------------------------

-- CASE

select nom,
case
	when P09_POP <500   then "Village"
	when P09_POP< 5000  then "Bourgade"
	else "Ville"
end
from popnord
where Nom like "A%";

---------------------------------------------------------------------------

select RegId,
case abrev
	when "" then nom
	else abrev
end
as "Abrev?" from regions;

---------------------------------------------------------------------------

-- différence avec ou sans DISTINCT

select distinct d.nom
from departements as d
join communes as c on d.DepId = c.DepId
join population p on p.CODGEO = c.ComId
where P09_POP<50;

---------------------------------------------------------------------------

select d.nom 
from departements as d
join communes as c on d.DepId = c.DepId
join population p on p.CODGEO = c.ComId
where P09_POP<50;

