-- Time-stamp: <2015-07-04 23:04:44 novatux>
-- Création : 2015-07-04T23:02:14+0200
-- 
-- Exemple de requêtes utilisables avec la base France et SQLite
-- Yvon Henel, alias « Le TeXnicien de surface »
---------------------------------------------------------------------------

SELECT d.nom, d.DepId, r.nom 
       FROM departements AS d 
       JOIN regions AS r ON d.RegId = r.RegId 	
       WHERE d.RegId = (
       	     SELECT RegId 
	     	    FROM departements 
	     	    WHERE nomsimp = "SEINE-ET-MARNE")

-- marche car la sous-requête ne renvoie qu'une valeur

---------------------------------------------------------------------------

SELECT d.nom, d.DepId, r.nom, r.RegId 
       FROM departements AS d 
       JOIN regions AS r ON d.RegId = r.RegId 
       WHERE d.RegId IN (
       	     SELECT RegId 
	     	    FROM departements 
		    WHERE nomsimp LIKE "SEINE%")
       ORDER BY r.RegId

-- récupère la liste des départements qui sont dans la même région qu'un
département dont le nom commence par SEINE (pris le NomSimp pour
éviter les problèmes d'accent, etc.)

---------------------------------------------------------------------------

SELECT  r.nom, d.nom, d.DepId, c.nom 
	FROM departements AS d 
	JOIN regions AS r ON d.RegId = r.RegId 
	JOIN communes AS c ON c.ComId = d.ChefLieu
	WHERE d.RegId IN (
	      SELECT RegId 
	      FROM departements 
	      WHERE nomsimp LIKE "SEINE%")
	ORDER BY r.RegId

---------------------------------------------------------------------------

SELECT  r.nom, d.nom, d.DepId, c.nom, 
  p.P09_POP AS "Population 2009", 
  ROUND((((p.P09_POP*1.0)/(p.P99_POP))-1)*100,2) AS "Croissance (%)"
	FROM departements AS d 
	JOIN regions      AS r ON d.RegId = r.RegId 
	JOIN communes     AS c ON c.ComId = d.ChefLieu
	JOIN population   AS p ON c.ComId = p.CodGeo
	WHERE d.RegId IN (
	      SELECT RegId FROM departements WHERE nomsimp LIKE "SEINE%")
	ORDER BY r.RegId

-- Multiplier une des populations par 1.0 est absolument obligatoire
sinon on obtient le quotient entier (les deux pop sont entières) et
l'affichage donne 0 partout.

---------------------------------------------------------------------------

SELECT  r.nom, d.nom, d.DepId, c.nom, 
  p.P09_POP AS "Population 2009", 
  ROUND((((p.P09_POP*1.0)/(p.P99_POP))-1)*100,2) AS "Croissance (%)",
  ROUND(p.P09_POP/(1000*Superf),2) AS "Densité"
	FROM departements AS d 
	JOIN regions      AS r ON d.RegId = r.RegId 
	JOIN communes     AS c ON c.ComId = d.ChefLieu
	JOIN population   AS p ON c.ComId = p.CodGeo
	WHERE d.RegId IN (
	      SELECT RegId FROM departements WHERE nomsimp LIKE "SEINE%")
	ORDER BY r.RegId

-- Ici no pb: la Superf(icie) est un réel.

---------------------------------------------------------------------------

SELECT COUNT(*) 
       FROM population 
       WHERE P09_POP > (
       	     SELECT AVG(P09_POP) FROM population)


