%% HYDVENG.CLS      
%%%%%%%%%%%%%  
% Classe d\'eriv\'ee d'article pour fiches d'exercices, les devoirs  
% d'aprs FICHE.CLS de D. Flipo  (Daniel.Flipo@univ-lille1.fr)  
% Yvon HeNeL  
% Usage :  
% \documentclass[12pt]{hydevoir}  
% La taille 12pt est recommand\'ee pour les r\'eductions ult\'erieures \`a  
% l'imprimerie.  
% Ajouts et modifications (par rapport \`a la classe article.cls :  
% -- taille de page A4, texte : largeur 160mm, hauteur 247mm (4 marges de 25mm)  
% -- les titres des parties sont centr\'es (pour les probl\`emes),  
%  
% Options possibles :  
% -- toutes celles d'article : 12pt, 11pt, a4paper, leqno, ...  
% -- seconly, (ou noitem),  pour ne r\'eduire que les tailles des fontes  
%    utilis\'ees dans les titres ;  
% -- itemonly, (ou nosec) pour ne r\'eduire que les  
%    espaces verticaux dans les listes.  
% Exemple : (l'ordre des options est sans importance)  
% \documentclass[seconly,12pt,leqno]{fiche}  
%  
%  
% Modifications :  
%  
  
\NeedsTeXFormat{LaTeX2e}  
%%% Identification  
\def\fileversion{v0.1}  
\def\filedate{1999/09/01}  
\ProvidesClass{hydveng}[\filedate\space\fileversion]  
  
%%% Code initial  
  
\RequirePackage{ifthen}  
\RequirePackage{calc}  
\RequirePackage{yhmacro}  
  
%%% D\'eclaration des options  
\DeclareOption{a5paper}{\PassOptionsToClass{a5paper}{article}}  
\DeclareOption{b5paper}{\PassOptionsToClass{b5paper}{article}}  
\DeclareOption{letterpaper}{\PassOptionsToClass{letterpaper}{article}}  
\DeclareOption{legalpaper}{\PassOptionsToClass{legalpaper}{article}}  
\DeclareOption{executivepaper}{\PassOptionsToClass{executivepaper}{article}}  
\DeclareOption{landscape}{\PassOptionsToClass{landscape}{article}}  
\DeclareOption{oneside}{\PassOptionsToClass{oneside}{article}}  
\DeclareOption{twoside}{\PassOptionsToClass{twoside}{article}}  
\DeclareOption{draft}{\PassOptionsToClass{draft}{article}}  
\DeclareOption{final}{\PassOptionsToClass{final}{article}}  
\DeclareOption{titlepage}{\PassOptionsToClass{titlepage}{article}}  
\DeclareOption{notitlepage}{\PassOptionsToClass{notitlepage}{article}}  
\DeclareOption{onecolumn}{\PassOptionsToClass{onecolumn}{article}}  
\DeclareOption{twocolumn}{\PassOptionsToClass{twocolumn}{article}}  
\DeclareOption{leqno}{\PassOptionsToClass{leqno}{article}}  
\DeclareOption{fleqn}{\PassOptionsToClass{fleqn}{article}}  
\DeclareOption{openbib}{\PassOptionsToClass{openbib}{article}}  
\DeclareOption{10pt}{\PassOptionsToClass{10pt}{article}}  
\DeclareOption{11pt}{\PassOptionsToClass{11pt}{article}}  
\DeclareOption{12pt}{\PassOptionsToClass{12pt}{article}}  
\DeclareOption{leqno}{\PassOptionsToClass{leqno}{article}}  
\DeclareOption{fleqn}{\PassOptionsToClass{fleqn}{article}}  
%  
\DeclareOption{nosec}{\NoSectrue}  
\DeclareOption{noitem}{\NoItemtrue}  
\DeclareOption{seconly}{\NoItemfalse}  
\DeclareOption{itemonly}{\NoSecfalse}  
  
  
%%% Ex\'ecution des options  
\ProcessOptions  
  
%%% Chargement de la classe standard 'article' au format A4  
\LoadClass[a4paper,10pt,oneside,onecolumn,final]{article}  
  
%%% Code Principal  
\AtBeginDocument{\thispagestyle{plain}}  
%\AtEndDocument{\addtocontents{aux}{\newlabel{LaPageDeFin}{{}{\thepage}}}}  
% a ne marche pas faudra revoir a !  
  
% Dimensions de page par d\'efaut  
\setlength{\hoffset}{-0.5cm}  
\setlength{\textwidth}{17cm}  
\setlength{\oddsidemargin}{0cm}  
\setlength{\evensidemargin}{0cm}  
\setlength{\marginparwidth}{0cm}  
\setlength{\marginparsep}{0cm}  
\setlength{\textheight}{24cm}  
\setlength{\topmargin}{-0.5cm}  
\setlength{\headheight}{0cm}  
\setlength{\headsep}{0.5cm}  
\setlength{\parindent}{0.5cm}  
\setlength{\parskip}{0pt}  
  
  
%Environement "exercices" bati sur "enumerate"   
\newenvironment{exercices}%  
{\begin{enumerate}%  
\renewcommand{\theenumi}{\textbf{\Roman{enumi}}}%  
\renewcommand{\labelenumi}{\theenumi}%  
\renewcommand{\theenumii}{\arabic{enumii}}%  
\renewcommand{\labelenumii}{\theenumii)}%  
\renewcommand{\p@enumii}{\theenumi--}%  
\renewcommand{\theenumiii}{\alph{enumiii}}%  
\renewcommand{\labelenumiii}{\theenumiii)}%  
\renewcommand{\p@enumiii}{\theenumii ; }%  
\renewcommand{\theenumiv}{\textit{\roman{enumiv}}}%  
\renewcommand{\labelenumiv}{\theenumiv)}%  
\renewcommand{\p@enumiv}{\theenumiii ;}%  
\setlength{\rightmargin}{0cm}  
\setlength{\partopsep}{0cm}  
\setlength{\topsep}{0cm}  
\setlength{\parskip}{2pt plus 1pt minus 2pt}  
}%  
{\end{enumerate}}  
  
  
\newcounter{NumeroPartie}  
%%% dclaration de la commande \partie  
\newcommand{\partie}[1]%  
{%  
\par%  
\stepcounter{NumeroPartie}%  
\medskip%  
\setlength{\parindent}{0cm}%  
\setlength{\hangindent}{0cm}%  
\par%  
\begin{center}%  
{\large \textsc{Partie} \Alph{NumeroPartie} --- { #1}}%  
\end{center}%  
}  
  
  
%%% renum\'erotation des pages  
\newcommand{\anneescol}{2000--2001}  
\newcommand{\@anneescol}{\makebox[5cm][r]{\anneescol}}  
\newcommand{\lycee}{\textsc{Lyc\'ee Montebello}}  
\newcommand{\@lycee}{\makebox[5cm][l]{\lycee}}  
\newcommand{\matiere}{\textsc{\textbf Mathematics}}  
\newcommand{\entete}{\@lycee\hspace{\stretch{1}}\matiere\hspace{\stretch{1}}\@anneescol}  
  
\renewcommand{\ps@plain}{%  
\renewcommand{\@oddhead}{}%      prs pour 2000-2001  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{\hfil\textrm{\thepage\ / \pageref{LaPageDeFin}}\hfil}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
%%% Pas d'entte et pas de pied de page  
\renewcommand{\ps@empty}{%  
\renewcommand{\@oddhead}{}%  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
%%% en tte sans pied de page   
\newcommand{\ps@sanspied}{%  
\renewcommand{\@oddhead}{\entete}%  
\renewcommand{\@evenhead}{}%  
\renewcommand{\@evenfoot}{}%  
\renewcommand{\@oddfoot}{\hfill{\rmfamily{\scriptsize {Henel} --- %  
\textsf{{\jobname}} --- \today}}}%  
}  
  
  
%%% en tte avec pied de page   
\newcommand{\ps@tetepiedspe}{%  
\renewcommand{\@oddhead}{\makebox[0.8\textwidth]{\large Name:\hrulefill}}%  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{\hfil\textrm{\thepage\ / \pageref{LaPageDeFin}}\hfil}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
%%% en tte avec pied de page   
\newcommand{\ps@tetepied}{%  
\renewcommand{\@oddhead}{\entete}%  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{\hfil\textrm{\thepage\ / \pageref{LaPageDeFin}}\hfil}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
  
\newenvironment{@changemargin}[1]{%  
\begin{list}{}{%  
\setlength{\labelwidth}{0pt}%  
\setlength{\labelsep}{-0.5em}%  
\setlength{\topsep}{0pt}%  
\setlength{\rightmargin}{0pt}%  
\setlength{\leftmargin}{#1}%  
\setlength{\listparindent}{\parindent}%  
\setlength{\itemindent}{\parindent}%  
\setlength{\parsep}{\parskip}%  
}%  
\item[]}{\end{list}}  
  
\newcounter{@Niveau}  
\newcounter{qstnumi}  
\newcounter{qstnumii}[qstnumi]  
\newcounter{qstnumiii}[qstnumii]  
\newcounter{qstnumiv}[qstnumiii]  
  
\renewcommand{\theqstnumi}{\textbf{\Roman{qstnumi}}}  
\renewcommand{\theqstnumii}{\arabic{qstnumii})}  
\renewcommand{\theqstnumiii}{\alph{qstnumiii})}  
\renewcommand{\theqstnumiv}{\textit{\modroman{qstnumiv}})}  
  
\newcommand{\@etiqui}[1]{\makebox[3em][c]{#1}}  
\newcommand{\@etiquii}[1]{\makebox[1.5em][c]{#1}}  
\newcommand{\@etiquiii}[1]{\makebox[1.5em][c]{#1}}  
\newcommand{\@etiquiv}[1]{\makebox[1.5em][c]{#1}}  
  
\newcommand{\q@stp}{%  
\ifthenelse{\value{@Niveau}=1}{\refstepcounter{qstnumi}\@etiqui{\theqstnumi}}{}%  
\ifthenelse{\value{@Niveau}=2}{\refstepcounter{qstnumii}\@etiquii{\theqstnumii}}{}%  
\ifthenelse{\value{@Niveau}=3}{\refstepcounter{qstnumiii}\@etiquiii{\theqstnumiii}}{}%  
\ifthenelse{\value{@Niveau}=4}{\refstepcounter{qstnumiv}\@etiquiv{\theqstnumiv}}{}%  
}  
  
\newcommand{\q@sts}{%  
\hspace{\stretch{1}}% pour que la premire fois on n'ait pas de blanc : marche pas  
\ifthenelse{\value{@Niveau}=1}{\refstepcounter{qstnumi}\@etiqui{\theqstnumi}}{}%  
\ifthenelse{\value{@Niveau}=2}{\refstepcounter{qstnumii}\@etiquii{\theqstnumii}}{}%  
\ifthenelse{\value{@Niveau}=3}{\refstepcounter{qstnumiii}\@etiquiii{\theqstnumiii}}{}%  
\ifthenelse{\value{@Niveau}=4}{\refstepcounter{qstnumiv}\@etiquiv{\theqstnumiv}}{}%  
}  
  
\newcommand{\q@sttbl}{%  
\ifthenelse{\value{@Niveau}=1}{\refstepcounter{qstnumi}\@etiqui{\theqstnumi}}{}%  
\ifthenelse{\value{@Niveau}=2}{\refstepcounter{qstnumii}\@etiquii{\theqstnumii}}{}%  
\ifthenelse{\value{@Niveau}=3}{\refstepcounter{qstnumiii}\@etiquiii{\theqstnumiii}}{}%  
\ifthenelse{\value{@Niveau}=4}{\refstepcounter{qstnumiv}\@etiquiv{\theqstnumiv}}{}%  
}  
  
\newcommand{\qst}{\q@stp}  
\newcommand{\qstsp}{\q@stp} %  revoir de plus prs  
  
\newboolean{@SansPar}  
  
\newlength{\retrait}  
\newlength{\Retrait}  
\setlength{\retrait}{1em}  
  
\newenvironment{exo}[1][!*!*!]%  
{%  
\ifthenelse{\equal{#1}{!*!*!}}%  
{\setboolean{@SansPar}{false}\renewcommand{\qst}{\q@stp}}%  
{\setboolean{@SansPar}{true}  
\ifthenelse{\equal{#1}{T}}{\renewcommand{\qst}{\q@sttbl}}{\renewcommand{\qst}{\q@sts}}}%  
\setlength{\Retrait}{\retrait*\value{@Niveau}}  
\begin{@changemargin}{\Retrait}%  
\addtocounter{@Niveau}{1}%  
}%  
{%  
\ifthenelse{\boolean{@SansPar}}{\hspace*{\stretch{1}}}{}\par%  
\end{@changemargin}%  
\addtocounter{@Niveau}{-1}%  
}  
  
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
%%%  la commande \titrang demande le nom de la classe puis le nom du texte  
%%%    
  
%nouvelle version au 1999/09/01 avec HYDVENG.CLS  
  
\newcommand{\@sousrepertoire}{}  
  
\newcommand{\@homework}[5]{%  
\renewcommand{\@sousrepertoire}{devns}\setlength{\parindent}{0pt}\par%  
{\Large \hspace*{\stretch{1}}{#1}\hspace*{\stretch{1}}\\[-1pt]%  
{Homework  #2}\hspace{\stretch{1}}\makebox[5cm][r]{for the \Date[e]{#3}{#4}{#5}}}\\[0pt]%  
\hrule\bigskip\par}  
  
\newcommand{\@test}[5]{%  
\renewcommand{\@sousrepertoire}{devsur}\setlength{\parindent}{0pt}\par%  
{\Large \hspace*{\stretch{1}}{#1}\hspace*{\stretch{1}}\\[-1pt]%  
{Test  #2}\hspace{\stretch{1}}\makebox[5cm][r]{\Date[e]{#3}{#4}{#5}}}\\[0pt]%  
\hrule\bigskip\par}  
  
\newcommand{\@exos}[5]{%  
\renewcommand{\@sousrepertoire}{exos}\setlength{\parindent}{0pt}\par%  
{\Large \hspace*{\stretch{1}}{#1}\hspace*{\stretch{1}}\\[-1pt]%  
{Paper  #2}\hspace{\stretch{1}}\makebox[5cm][r]{\Date[e]{#3}{#4}{#5}}}\\[0pt]%  
\hrule\bigskip\par}  
  
\newcommand{\@other}[5]{%  
\renewcommand{\@sousrepertoire}{autres}\setlength{\parindent}{0pt}\par%  
{\Large \hspace*{\stretch{1}}{#1}\hspace*{\stretch{1}}\\[-1pt]%  
{#2}\hspace{\stretch{1}}\makebox[5cm][r]{\Date[e]{#3}{#4}{#5}}}\\[0pt]%  
\hrule\bigskip\par}  
  
\newcommand{\titrang}[6][m]{%  
\ifthenelse{\equal{#1}{m}}{\@homework{#2}{#3}{#4}{#5}{#6}}{}%  
\ifthenelse{\equal{#1}{s}}{\@test{#2}{#3}{#4}{#5}{#6}}{}%  
\ifthenelse{\equal{#1}{e}}{\@exos{#2}{#3}{#4}{#5}{#6}}{}%  
\ifthenelse{\equal{#1}{a}}{\@other{#2}{#3}{#4}{#5}{#6}}{}%  
}  
  
\newboolean{montrerreponses}\setboolean{montrerreponses}{false}  
\newcommand{\AvecRep}{\setboolean{montrerreponses}{true}}  
\newcommand{\answer}[1]{\ifthenelse{\boolean{montrerreponses}}{{\sffamily Answer: #1}}{}}  
  
\newboolean{montrerprononciation}\setboolean{montrerprononciation}{false}  
\newcommand{\AvecPron}{\setboolean{montrerprononciation}{true}}  
\newcommand{\Prn}[1]{\ifthenelse{\boolean{montrerprononciation}}{{\rmfamily\upshape[#1]}}{}}  
  
\newboolean{montrercommentaires}\setboolean{montrercommentaires}{false}  
\newcommand{\AvecCom}{\setboolean{montrercommentaires}{true}}  
\newcommand{\Commentaires}[1]{\ifthenelse{\boolean{montrercommentaires}}{\input{#1.kom}}{}}  
  
\newboolean{pourleprofesseur}\setboolean{pourleprofesseur}{false}  
\newcommand{\RepereFichier}{\setboolean{pourleprofesseur}{true}}  
\newcommand{\nomtr@v@il}{\jobname}  
\newcommand{\inserer}[1]{\renewcommand{\nomtr@v@il}{#1}%  
\ifthenelse{\boolean{pourleprofesseur}}{\marginpar{\footnotesize\ttfamily\nomtr@v@il}}{}%  
\input{\@sousrepertoire/#1}}   
  
\newcommand{\ExoSeul}{%  
\renewcommand{\theqstnumi}{\arabic{qstnumi})}%  
\renewcommand{\theqstnumii}{\alph{qstnumii})}%  
\renewcommand{\theqstnumiii}{\textit{\modroman{qstnumiii}})}%  
\renewcommand{\theqstnumiv}{\engrec{qstnumiv})}%  
}  
  
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
  
% \label, apr\`es un num\'ero de question peut introduire un espace parasite.  
\let\F@label\label  
\renewcommand{\label}[1]{\F@label{#1}\ignorespaces}  
  
% Red\'efinition de \part : num\'ero centr\'e en gras  
\renewcommand{\part}{\par  
   \addvspace{2ex}%  
   \setcounter{section}{0}%  
   \@afterindentfalse  
   \secdef\@part\@spart}  
\def\@part[#1]#2{\refstepcounter{part}%  
    \ifnum \c@secnumdepth >\m@ne  
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%  
    \else  
      \addcontentsline{toc}{part}{#1}%  
    \fi  
    \@spart{\thepart\hspace{0.5em}#2}}  
\def\@spart#1{%  
     {\centering  
      \interlinepenalty \@M  
      \reset@font \Large\bfseries #1%  
      \markboth{}{}\par}%  
      \nobreak  
      \vskip 2ex  
      \@afterheading}  
  
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
  
\endinput  
  
%%  
%%  
%% Fin du fichier `HYDEVOIR.cls'.  
