%% HYDEVOIR.CLS   
%%%%%%%%%%%%%  
% Classe d\'eriv\'ee d'article pour fiches d'exercices, les devoirs  
% d'aprs FICHE.CLS de D. Flipo  (Daniel.Flipo@univ-lille1.fr)  
% Yvon HeNeL  
% Ajouts et modifications (par rapport \`a la classe article.cls :  
% -- taille de page A4, texte : largeur 160mm, hauteur 247mm (4 marges de 25mm)  
% -- les titres des parties sont centr\'es (pour les probl\`emes),  
%  
% Options possibles :  
% -- toutes celles d'article : 12pt, 11pt, a4paper, leqno, ...  
% -- seconly, (ou noitem),  pour ne r\'eduire que les tailles des fontes  
%    utilis\'ees dans les titres ;  
% -- itemonly, (ou nosec) pour ne r\'eduire que les  
%    espaces verticaux dans les listes.  
% Exemple : (l'ordre des options est sans importance)  
% \documentclass[seconly,12pt,leqno]{fiche}  
%  
% Modifications :  
%  
% ** redfinit les dimensions de la partie utile de la page  
%  ** procure les environnements :  
%     *** << exo >> du genre << itemize >>  
%     avec << qst >>  la place de << item >>  
%     *** << exercice >> bati sur << enumerate >>  
%     *** << problo >>  
%  ** procure la commande << ExoSeul >>  utiliser avant l'environnement << exo >>  
%  
  
\NeedsTeXFormat{LaTeX2e}  
%%% Identification  
\def\fileversion{v0.1}  
\def\filedate{2000/02/10}  
\ProvidesClass{hydev}[\filedate\space\fileversion]  
  
%%% Code initial  
  
\RequirePackage{ifthen}  
\RequirePackage{calc}  
\RequirePackage{yhmacro}  
\RequirePackage{fancybox}  
  
%%% D\'eclaration des options  
\DeclareOption{a5paper}{\PassOptionsToClass{a5paper}{article}}  
\DeclareOption{b5paper}{\PassOptionsToClass{b5paper}{article}}  
\DeclareOption{letterpaper}{\PassOptionsToClass{letterpaper}{article}}  
\DeclareOption{legalpaper}{\PassOptionsToClass{legalpaper}{article}}  
\DeclareOption{executivepaper}{\PassOptionsToClass{executivepaper}{article}}  
\DeclareOption{landscape}{\PassOptionsToClass{landscape}{article}}  
\DeclareOption{oneside}{\PassOptionsToClass{oneside}{article}}  
\DeclareOption{twoside}{\PassOptionsToClass{twoside}{article}}  
\DeclareOption{draft}{\PassOptionsToClass{draft}{article}}  
\DeclareOption{final}{\PassOptionsToClass{final}{article}}  
\DeclareOption{titlepage}{\PassOptionsToClass{titlepage}{article}}  
\DeclareOption{notitlepage}{\PassOptionsToClass{notitlepage}{article}}  
\DeclareOption{onecolumn}{\PassOptionsToClass{onecolumn}{article}}  
\DeclareOption{twocolumn}{\PassOptionsToClass{twocolumn}{article}}  
\DeclareOption{leqno}{\PassOptionsToClass{leqno}{article}}  
\DeclareOption{fleqn}{\PassOptionsToClass{fleqn}{article}}  
\DeclareOption{openbib}{\PassOptionsToClass{openbib}{article}}  
\DeclareOption{10pt}{\PassOptionsToClass{10pt}{article}}  
\DeclareOption{11pt}{\PassOptionsToClass{11pt}{article}}  
\DeclareOption{12pt}{\PassOptionsToClass{12pt}{article}}  
\DeclareOption{leqno}{\PassOptionsToClass{leqno}{article}}  
\DeclareOption{fleqn}{\PassOptionsToClass{fleqn}{article}}  
%  
\DeclareOption{nosec}{\NoSectrue}  
\DeclareOption{noitem}{\NoItemtrue}  
\DeclareOption{seconly}{\NoItemfalse}  
\DeclareOption{itemonly}{\NoSecfalse}  
  
%%% Ex\'ecution des options  
\ProcessOptions  
  
%%% Chargement de la classe standard 'article' au format A4  
\LoadClass[a4paper]{article}  
  
%%% Code Principal  
  
% Dimensions de page par d\'efaut  
\setlength{\hoffset}{-0.5cm}  
\setlength{\textwidth}{17cm}  
\setlength{\oddsidemargin}{0cm}  
\setlength{\evensidemargin}{0cm}  
\setlength{\marginparwidth}{0cm}  
\setlength{\marginparsep}{0cm}  
\setlength{\textheight}{24cm}  
\setlength{\topmargin}{-0.5cm}  
\setlength{\headheight}{0cm}  
\setlength{\headsep}{0.5cm}  
\setlength{\parindent}{0.5cm}  
\setlength{\parskip}{0pt}  
  
%Environnement "exercices" bati sur "enumerate"   
\newenvironment{exercices}%  
{\begin{enumerate}%  
\renewcommand{\theenumi}{\textbf{\Roman{enumi}}}%  
\renewcommand{\labelenumi}{\theenumi}%  
\renewcommand{\theenumii}{\arabic{enumii}}%  
\renewcommand{\labelenumii}{\theenumii)}%  
\renewcommand{\p@enumii}{\theenumi--}%  
\renewcommand{\theenumiii}{\alph{enumiii}}%  
\renewcommand{\labelenumiii}{\theenumiii)}%  
\renewcommand{\p@enumiii}{\theenumii ; }%  
\renewcommand{\theenumiv}{\textit{\roman{enumiv}}}%  
\renewcommand{\labelenumiv}{\theenumiv)}%  
\renewcommand{\p@enumiv}{\theenumiii ;}%  
\setlength{\rightmargin}{0cm}  
\setlength{\partopsep}{0cm}  
\setlength{\topsep}{0cm}  
\setlength{\parskip}{2pt plus 1pt minus 2pt}  
}%  
{\end{enumerate}}  
  
\newcounter{NumeroPartie}  
%%% dclaration de la commande \Partie  
\newcommand{\Partie}[1]%  
{%  
\par%  
\stepcounter{NumeroPartie}%  
\medskip%  
\setlength{\parindent}{0cm}%  
\setlength{\hangindent}{0cm}%  
\par%  
\begin{center}%  
{\large \textsc{Partie} \Alph{NumeroPartie} --- { #1}}%  
\end{center}%  
}  
  
%%% renum\'erotation des pages  
\newcommand{\anneescol}{2000--2001}  
\newcommand{\@anneescol}{\makebox[5cm][r]{\anneescol}}  
\newcommand{\lycee}{\textsc{Lyc\'ee Montebello}}  
\newcommand{\@lycee}{\makebox[5cm][l]{\lycee}}  
\newcommand{\matiere}{\textsc{\textbf Math\'ematiques}}  
\newcommand{\@matiere}{\makebox[5cm][l]{\matiere}}  
\newcommand{\entete}{\@lycee\hspace{\stretch{1}}\matiere\hspace{\stretch{1}}\@anneescol}  
\newcommand{\version}{\texttt{version du \today}}  
\newcommand{\@version}{\makebox[5cm][r]{\version}}  
\renewcommand{\ps@plain}{%  
\renewcommand{\@oddhead}{\ifthenelse{\value{page}=1}{\entete}{}}%  prs pour 2000-2001  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{%  
\ifthenelse{\value{page}=1}  
{\thepage\ / \pageref{LaPageDeFin}\hfill%  
{\rmfamily\scriptsize Henel --- \texttt{\lowercase\expandafter{\jobname}} --- \today}  
}  
{\hfill\thepage\ / \pageref{LaPageDeFin}\hfill}  
}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
%%%   
\renewcommand{\ps@empty}{%  
\renewcommand{\@oddhead}{\entete}%  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
%%% en tte sans numro de page  
\newcommand{\ps@sanspied}{%  
\renewcommand{\@oddhead}{\entete}%  
\renewcommand{\@evenhead}{}%  
\renewcommand{\@evenfoot}{}%  
\renewcommand{\@oddfoot}{\hfill{\rmfamily{\scriptsize {Henel} --- %  
\texttt{\lowercase\expandafter{\jobname}} --- \today}}}%  
}  
  
%%% pour devoir commun de 2de  
\newcommand{\DEVCOM}{\footnotesize\@matiere\hfill\textsc{Devoir commun de seconde}}  
\newcommand{\ps@devcom}{%  
\renewcommand{\@oddhead}{\ifthenelse{\value{page}=1}{\entete}{\DEVCOM}}%  
\renewcommand{\@evenhead}{\@oddhead}%  
\renewcommand{\@evenfoot}{\hfill\thepage\ / \pageref{LaPageDeFin}\hfill}%  
\renewcommand{\@oddfoot}{\@evenfoot}%  
}  
  
\newenvironment{@changemargin}[1]{%  
\begin{list}{}{%  
\setlength{\labelwidth}{0pt}%  
\setlength{\labelsep}{-0.5em}%  
\setlength{\topsep}{0pt}%  
\setlength{\rightmargin}{0pt}%  
\setlength{\leftmargin}{#1}%  
\setlength{\listparindent}{\parindent}%  
\setlength{\itemindent}{\parindent}%  
\setlength{\parsep}{\parskip}%  
}%  
\item[]}{\end{list}}  
  
\newcounter{@Niveau}  
\newcounter{exonum}  
\newcounter{qstnumi}[exonum]  
\newcounter{qstnumii}[qstnumi]  
\newcounter{qstnumiii}[qstnumii]  
\newcounter{qstnumiv}[qstnumiii]  
  
\renewcommand{\theqstnumi}{\textbf{\Roman{qstnumi}}}  
\renewcommand{\theqstnumii}{\arabic{qstnumii})}  
\renewcommand{\theqstnumiii}{\alph{qstnumiii})}  
\renewcommand{\theqstnumiv}{\textit{\modroman{qstnumiv}})}  
  
\newcommand{\ExoSeul}{%  
\renewcommand{\theqstnumi}{\arabic{qstnumi})}%  
\renewcommand{\theqstnumii}{\alph{qstnumii})}%  
\renewcommand{\theqstnumiii}{\textit{\modroman{qstnumiii}})}%  
\renewcommand{\theqstnumiv}{\engrec{qstnumiv})}%  
}  
  
\newlength{\retrait}  
\newlength{\REtrait}  
\newlength{\Retrait}  
\setlength{\retrait}{1em}  
\setlength{\REtrait}{2em}  
  
\newcommand{\@etiqu}[1]{\makebox[\REtrait][c]{#1}}  
  
\newcommand{\qst}{%  
\ifthenelse{\value{@Niveau}=1}%  
{\setlength{\REtrait}{2.5em}\refstepcounter{qstnumi}\@etiqu{\theqstnumi}}{}%  
\ifthenelse{\value{@Niveau}=2}%  
{\setlength{\REtrait}{2em}\refstepcounter{qstnumii}\@etiqu{\theqstnumii}}{}%  
\ifthenelse{\value{@Niveau}=3}%  
{\setlength{\REtrait}{1.8em}\refstepcounter{qstnumiii}\@etiqu{\theqstnumiii}}{}%  
\ifthenelse{\value{@Niveau}=4}%  
{\setlength{\REtrait}{1em}\refstepcounter{qstnumiv}\@etiqu{\theqstnumiv} }{}%  
}  
  
  
\newenvironment{exo}%  
{%  
\ifthenelse{\value{@Niveau}=0}{\stepcounter{exonum}}{}%  
\setlength{\Retrait}{\retrait*\value{@Niveau}}%  
\begin{@changemargin}{\Retrait}%  
\addtocounter{@Niveau}{1}%  
}%  
{\end{@changemargin}%  
\addtocounter{@Niveau}{-1}%  
}  
  
%%% addition du 10/02/2000 (pour bacc...)  
  
\newcounter{p@rtie}  
\renewcommand{\thep@rtie}{\Alph{p@rtie}}  
  
\newenvironment{problo}%  
{%  
\setcounter{p@rtie}{0}%  
\setcounter{@Niveau}{1}%  
\setcounter{qstnumii}{0}%  
\hspace*{\stretch{1}}{\Large\textsc{Probl\`eme}}\hspace*{\stretch{1}}%  
\par}%  
{}  
  
%%%  mettre au point !  
  
\newcommand{\partie}[1][n]{%  
\refstepcounter{p@rtie}%  
\par%  
\ifthenelse{\equal{#1}{n}}%  
{\renewcommand{\thep@rtie}{\Alph{p@rtie}}%  
\hspace*{\stretch{1}}\textsc{Partie} \thep@rtie\hspace*{\stretch{1}}}% alors  
{\renewcommand{\thep@rtie}{\Roman{p@rtie}}%  
\textsc{Partie} \thep@rtie}% sinon  
\par%  
\setcounter{@Niveau}{1}%  
\setcounter{qstnumii}{0}%  
}  
  
%%% fin addition du 10/02/2000  
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
  
\endinput  
  
%%  
%%  
%% Fin du fichier `HYDEV.cls'.  
  
  
  
  
  
  
  
  
